/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.visu;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.TGException;
import java.awt.Color;
import java.awt.Image;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import net.jxta.peergroup.PeerGroup;
import p2pmpi.message.StatInfoMessage;
import p2pmpi.message.StatQueryMessage;
import p2pmpi.mpd.MPDAdv;
import p2pmpi.visu.P2PMPI_Visu;
import p2pmpi.visu.PeerNode;

public class StatQuery
extends Thread {
    P2PMPI_Visu parent;
    MPDAdv mpdadv;
    PeerGroup mpipg;
    Image img;

    public StatQuery(P2PMPI_Visu p2PMPI_Visu, MPDAdv mPDAdv, PeerGroup peerGroup) {
        this.parent = p2PMPI_Visu;
        this.mpdadv = mPDAdv;
        this.mpipg = peerGroup;
    }

    private String whois(String string) {
        String string2 = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            String string3 = inetAddress.getCanonicalHostName();
            string2 = string3.matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}") ? "unregistered" : string3.substring(string3.indexOf(46) + 1);
        }
        catch (UnknownHostException unknownHostException) {
            string2 = "Unresolved";
        }
        return string2;
    }

    public void run() {
        Object object;
        String string = this.mpdadv.getName();
        String string2 = this.mpdadv.getIP();
        boolean bl = false;
        StatInfoMessage statInfoMessage = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        ObjectOutputStream objectOutputStream = null;
        Socket socket = null;
        ObjectInputStream objectInputStream = null;
        try {
            object = new StatQueryMessage();
            socket = new Socket(string2, this.mpdadv.getMPDPort());
            inputStream = socket.getInputStream();
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            objectInputStream = new ObjectInputStream(inputStream);
            statInfoMessage = (StatInfoMessage)objectInputStream.readObject();
            objectInputStream.close();
            objectOutputStream.close();
            inputStream.close();
            outputStream.close();
            socket.close();
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl && statInfoMessage != null) {
            object = this.parent.jc2.findNode(string2);
            if (object != null) {
                ((PeerNode)object).setStatus("Available");
            } else {
                String string3 = this.whois(string);
                int n = string.indexOf(".");
                String string4 = n > 0 && n < string.length() ? string.substring(0, n) : string;
                PeerNode peerNode = new PeerNode(string2, string4, this.parent);
                peerNode.setHostName(string);
                peerNode.setIP(string2);
                peerNode.setOSname(this.mpdadv.getOS());
                peerNode.setMemory(this.mpdadv.getMem());
                peerNode.setCpu(this.mpdadv.getCpuName());
                peerNode.setCpuFreq(this.mpdadv.getCpuFreq());
                peerNode.setDomainName(string3);
                peerNode.setStatus("Available");
                this.parent.peers.addElement(peerNode);
                PeerNode peerNode2 = this.parent.jc2.findNode(string3);
                if (peerNode2 == null) {
                    try {
                        peerNode2 = new PeerNode(string3, string3);
                        peerNode2.setBackColor(Color.WHITE);
                        peerNode2.setType(3);
                        peerNode2.setTextColor(Color.BLACK);
                        this.parent.jc2.addNode(peerNode2);
                    }
                    catch (TGException tGException) {
                        // empty catch block
                    }
                }
                peerNode.setType(2);
                peerNode.setHint("IP: " + string2 + "\nStatus: Available\nOS: ");
                peerNode.setBackColor(Color.decode("#4080A0"));
                try {
                    this.parent.jc2.addNode(peerNode);
                    Edge edge = this.parent.jc2.addEdge(peerNode, peerNode2, 2 * Edge.DEFAULT_LENGTH);
                }
                catch (TGException tGException) {
                    // empty catch block
                }
            }
            int n = statInfoMessage.size();
            if (n > 0) {
                this.parent.infoMsgs.addElement(statInfoMessage);
            }
            this.parent.fillPeers();
            if (this.parent.fen != null) {
                this.parent.fen.refresh();
            }
            this.parent.refreshTables();
        }
    }
}

