/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Vector;
import p2pmpi.common.OutputMessage;
import p2pmpi.common.RankTable;
import p2pmpi.common.Tag;
import p2pmpi.message.AliveMessage;
import p2pmpi.message.DataMessage;
import p2pmpi.message.FinalizedConfirmMessage;
import p2pmpi.message.FinalizedMessage;
import p2pmpi.message.IsAliveMessage;
import p2pmpi.message.MPIMessage;
import p2pmpi.message.NoAliveMessage;
import p2pmpi.message.NotifyMessage;
import p2pmpi.message.RequestQuitMessage;
import p2pmpi.message.UpdateStatusMessage;
import p2pmpi.mpi.internal.IStatus;
import p2pmpi.mpi.internal.MessageIDLog;
import p2pmpi.mpi.internal.RecvBufferInformation;
import p2pmpi.mpi.internal.SendBufferInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHandler
implements Runnable {
    private String key;
    private boolean ready;
    private boolean terminated;
    private ServerSocket servSocket = null;
    private RankTable rankTable;
    private int myRank;
    private int myRankInList;
    private int commSize;
    private int mpdPort;
    private Vector<RecvBufferInformation> messageBuffer;
    private MessageIDLog recvLog;
    private Vector<SendBufferInformation> backupBuffer;
    private MessageIDLog sendLog;
    private int myMaster;
    private boolean master;
    private volatile boolean shutdown = false;
    private boolean rankZero;

    public MessageHandler(ServerSocket serverSocket, int n, RankTable rankTable, String string, int n2) {
        this.commSize = n;
        this.key = string;
        this.rankTable = rankTable;
        this.ready = false;
        this.terminated = false;
        this.rankZero = true;
        this.mpdPort = n2;
        this.messageBuffer = new Vector();
        this.recvLog = new MessageIDLog();
        this.shutdown = false;
        this.servSocket = serverSocket;
        try {
            this.servSocket.setSoTimeout(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MessageHandler(ServerSocket serverSocket, String string, int n) {
        this.key = string;
        this.ready = false;
        this.mpdPort = n;
        this.messageBuffer = new Vector();
        this.recvLog = new MessageIDLog();
        this.shutdown = false;
        this.rankZero = false;
        this.servSocket = serverSocket;
        try {
            this.servSocket.setSoTimeout(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.shutdown = true;
        try {
            if (this.servSocket != null) {
                this.servSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean bl) {
        this.master = bl;
    }

    public void setMyMaster(int n) {
        this.myMaster = n;
    }

    public void setSendBackupAndLog(Vector<SendBufferInformation> vector, MessageIDLog messageIDLog) {
        this.backupBuffer = vector;
        this.sendLog = messageIDLog;
    }

    public void setRankTable(RankTable rankTable) {
        this.rankTable = rankTable;
    }

    public RankTable getRankTable() {
        return this.rankTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Socket socket = null;
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        Object object = null;
        RecvBufferInformation recvBufferInformation = null;
        if (!this.rankZero) {
            try {
                this.servSocket.setSoTimeout(120000);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        while (!this.shutdown) {
            String string;
            Serializable serializable;
            try {
                socket = this.servSocket.accept();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                System.exit(1);
            }
            catch (IOException iOException) {
                continue;
            }
            try {
                inputStream = socket.getInputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                object = objectInputStream.readObject();
            }
            catch (Exception exception) {
                try {
                    objectInputStream.close();
                    inputStream.close();
                    socket.close();
                }
                catch (Exception exception2) {}
                continue;
            }
            if (object instanceof MPIMessage) {
                serializable = (MPIMessage)object;
                switch (((MPIMessage)serializable).getCmd()) {
                    case 12: {
                        this.ready = true;
                        this.myRank = ((MPIMessage)serializable).getRank();
                        this.myRankInList = ((MPIMessage)serializable).getRankInList();
                        this.commSize = ((MPIMessage)serializable).getSize();
                        this.setRankTable(((MPIMessage)serializable).getCommTable());
                        try {
                            this.servSocket.setSoTimeout(0);
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            } else if (object instanceof DataMessage) {
                serializable = (DataMessage)object;
                string = ((DataMessage)serializable).getMID();
                if (this.recvLog.isExist(string) == -1) {
                    recvBufferInformation = new RecvBufferInformation(((DataMessage)serializable).getMID(), ((DataMessage)serializable).getFromRank(), ((DataMessage)serializable).getToRank(), ((DataMessage)serializable).getData(), ((DataMessage)serializable).getTag());
                    Object object2 = this.messageBuffer;
                    synchronized (object2) {
                        this.messageBuffer.addElement(recvBufferInformation);
                    }
                    object2 = this.recvLog;
                    synchronized (object2) {
                        this.recvLog.add(string);
                    }
                }
            } else {
                Serializable serializable2;
                Object object3;
                Vector<SendBufferInformation> vector;
                if (object instanceof UpdateStatusMessage) {
                    int n;
                    serializable = (UpdateStatusMessage)object;
                    while (this.sendLog == null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {}
                    }
                    string = ((UpdateStatusMessage)serializable).getMID();
                    vector = this.sendLog;
                    synchronized (vector) {
                        n = this.sendLog.isExist(string);
                    }
                    if (n != -1) {
                        vector = this.sendLog;
                        synchronized (vector) {
                            this.sendLog.remove(string);
                        }
                        vector = this.backupBuffer;
                        synchronized (vector) {
                            this.backupBuffer.removeElementAt(n);
                        }
                    }
                    vector = this.sendLog;
                    synchronized (vector) {
                        this.sendLog.add(string);
                    }
                }
                if (object instanceof NotifyMessage) {
                    serializable = (NotifyMessage)object;
                    int n = ((NotifyMessage)serializable).getRankInList();
                    RankTable rankTable = this.rankTable;
                    synchronized (rankTable) {
                        this.rankTable.setAlive(n, false);
                        this.rankTable.setTerminated(n, true);
                    }
                    int n2 = this.rankTable.size();
                    if (n == 0) {
                        System.out.println("[Warning] Rank 0 crashes, quit application");
                        System.exit(1);
                    }
                    object3 = new boolean[this.commSize];
                    for (int i = 0; i < this.commSize; ++i) {
                        object3[i] = false;
                    }
                    RankTable rankTable2 = this.rankTable;
                    synchronized (rankTable2) {
                        for (int i = 0; i < n2; ++i) {
                            if (!this.rankTable.isAlive(i)) continue;
                            object3[this.rankTable.getRank((int)i)] = true;
                        }
                    }
                    for (int i = 0; i < this.commSize; ++i) {
                        if (object3[i] != false) continue;
                        System.out.println("[Error] Not even one replica of rank " + i + " survives. Application can not be terminated");
                        System.exit(1);
                    }
                    serializable2 = new NotifyMessage(this.key + "--" + this.myRank, n);
                    try {
                        Socket socket2 = new Socket("127.0.0.1", this.mpdPort);
                        OutputStream outputStream = socket2.getOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                        objectOutputStream.writeObject(serializable2);
                        objectOutputStream.flush();
                        objectOutputStream.close();
                        outputStream.close();
                        socket2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n == this.myMaster) {
                        int n3 = this.myRankInList;
                        int n4 = this.rankTable.size();
                        for (int i = 0; i < n4; ++i) {
                            if (this.myRank != this.rankTable.getRank(i) || !this.rankTable.isAlive(i)) continue;
                            if (n3 <= i) {
                                this.myMaster = i;
                                this.master = true;
                                break;
                            }
                            this.master = false;
                            this.myMaster = i;
                            break;
                        }
                        if (this.master) {
                            Vector<SendBufferInformation> vector2 = this.backupBuffer;
                            synchronized (vector2) {
                                while (this.backupBuffer.size() != 0) {
                                    ObjectOutputStream objectOutputStream;
                                    OutputStream outputStream;
                                    Socket socket3;
                                    SendBufferInformation sendBufferInformation = this.backupBuffer.elementAt(0);
                                    Vector<URI> vector3 = this.rankTable.getURIByRank(sendBufferInformation.toRank());
                                    int n5 = vector3.size();
                                    for (int i = 0; i < n5; ++i) {
                                        try {
                                            URI uRI = vector3.elementAt(i);
                                            socket3 = new Socket(uRI.getHost(), uRI.getPort());
                                            outputStream = socket3.getOutputStream();
                                            objectOutputStream = new ObjectOutputStream(outputStream);
                                            objectOutputStream.writeObject(sendBufferInformation.getData());
                                            objectOutputStream.flush();
                                            objectOutputStream.close();
                                            outputStream.close();
                                            socket3.close();
                                            continue;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    UpdateStatusMessage updateStatusMessage = new UpdateStatusMessage(sendBufferInformation.getMID());
                                    Vector<Integer> vector4 = this.rankTable.getRankInListByRank(this.myRank);
                                    int n6 = vector4.size();
                                    for (int i = 0; i < n6; ++i) {
                                        int n7 = vector4.elementAt(i);
                                        try {
                                            if (n7 == this.myRankInList || !this.rankTable.isAlive(n7)) continue;
                                            socket3 = new Socket(this.rankTable.getHost(n7), this.rankTable.getPort(n7));
                                            outputStream = socket3.getOutputStream();
                                            objectOutputStream = new ObjectOutputStream(outputStream);
                                            objectOutputStream.writeObject(updateStatusMessage);
                                            objectOutputStream.flush();
                                            objectOutputStream.close();
                                            outputStream.close();
                                            socket3.close();
                                            continue;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    this.backupBuffer.removeElementAt(0);
                                    this.sendLog.remove(sendBufferInformation.getMID());
                                }
                            }
                        }
                    }
                } else if (object instanceof IsAliveMessage) {
                    serializable = (IsAliveMessage)object;
                    Object var8_19 = null;
                    vector = null;
                    object3 = null;
                    if (this.key.equals(((IsAliveMessage)serializable).getKey())) {
                        serializable2 = new AliveMessage(this.key);
                        try {
                            vector = socket.getOutputStream();
                            object3 = new ObjectOutputStream((OutputStream)((Object)vector));
                            ((ObjectOutputStream)object3).writeObject(serializable2);
                            ((ObjectOutputStream)object3).close();
                            ((OutputStream)((Object)vector)).close();
                        }
                        catch (Exception exception) {}
                    } else {
                        serializable2 = new NoAliveMessage();
                        try {
                            vector = socket.getOutputStream();
                            object3 = new ObjectOutputStream((OutputStream)((Object)vector));
                            ((ObjectOutputStream)object3).writeObject(serializable2);
                            ((ObjectOutputStream)object3).close();
                            ((OutputStream)((Object)vector)).close();
                        }
                        catch (Exception exception) {}
                    }
                } else if (object instanceof FinalizedMessage) {
                    serializable = (FinalizedMessage)object;
                    int n = ((FinalizedMessage)serializable).getRankInList();
                    vector = this.rankTable;
                    synchronized (vector) {
                        this.rankTable.setTerminated(n, true);
                    }
                } else if (object instanceof FinalizedConfirmMessage) {
                    this.terminated = true;
                } else if (object instanceof RequestQuitMessage) {
                    System.exit(0);
                } else if (object instanceof OutputMessage) {
                    serializable = (OutputMessage)object;
                    System.out.println(((OutputMessage)serializable).getOutput());
                } else {
                    System.out.println("[Warning] received unknow type of message");
                }
            }
            try {
                objectInputStream.close();
                inputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                System.out.println("[Error] cannot close communication, maybe a network problem");
            }
        }
    }

    public int getMessageBufferSize() {
        return this.messageBuffer.size();
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllTerminated() {
        RankTable rankTable = this.rankTable;
        synchronized (rankTable) {
            for (int i = 0; i < this.rankTable.size(); ++i) {
                if (this.rankTable.isTerminated(i)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void meTerminated() {
        RankTable rankTable = this.rankTable;
        synchronized (rankTable) {
            this.rankTable.setTerminated(0, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDataFromBuffer(int n, int n2, int n3, IStatus iStatus) {
        Vector<RecvBufferInformation> vector = this.messageBuffer;
        synchronized (vector) {
            int n4 = this.messageBuffer.size();
            for (int i = 0; i < n4; ++i) {
                boolean bl;
                RecvBufferInformation recvBufferInformation = this.messageBuffer.elementAt(i);
                boolean bl2 = recvBufferInformation.fromRank() == n && recvBufferInformation.toRank() == n2;
                boolean bl3 = recvBufferInformation.getTag() == n3;
                boolean bl4 = n == Tag.MPI_ANYSOURCE;
                boolean bl5 = bl = n3 == Tag.MPI_ANYTAG;
                if (!bl2 && !bl4 || !bl3 && !bl) continue;
                iStatus.setStatus(recvBufferInformation.fromRank(), recvBufferInformation.getTag());
                return recvBufferInformation.getData();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataFromBuffer(int n, int n2, int n3) {
        Vector<RecvBufferInformation> vector = this.messageBuffer;
        synchronized (vector) {
            int n4 = this.messageBuffer.size();
            for (int i = 0; i < n4; ++i) {
                RecvBufferInformation recvBufferInformation = this.messageBuffer.elementAt(i);
                if (recvBufferInformation.fromRank() != n || recvBufferInformation.toRank() != n2 || recvBufferInformation.getTag() != n3) continue;
                this.messageBuffer.removeElementAt(i);
                return;
            }
        }
    }

    public int getRank() {
        return this.myRank;
    }

    public int getRankInList() {
        return this.myRankInList;
    }

    public int getCommSize() {
        return this.commSize;
    }

    public void stop() {
        try {
            this.servSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

