/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import p2pmpi.mpi.Comm;
import p2pmpi.mpi.Datatype;
import p2pmpi.mpi.Status;
import p2pmpi.mpi.internal.IStatus;
import p2pmpi.mpi.internal.MessageHandler;

public class Request {
    protected MessageHandler msgHandle = null;
    protected Object recvBuffer;
    protected int offset;
    protected int count;
    protected Datatype datatype;
    protected int src;
    protected int tag;
    protected int dst;

    public Request(MessageHandler messageHandler, Object object, int n, int n2, Datatype datatype, int n3, int n4, int n5) {
        this.msgHandle = messageHandler;
        this.recvBuffer = object;
        this.offset = n;
        this.count = n2;
        this.datatype = datatype;
        this.src = n3;
        this.tag = n4;
        this.dst = n5;
    }

    public Status Wait() {
        int n;
        Object object;
        IStatus iStatus = new IStatus(this.src, this.tag, 0);
        Status status = null;
        while (true) {
            if ((object = this.msgHandle.getDataFromBuffer(this.src, this.dst, this.tag, iStatus)) != null) break;
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        status = new Status(iStatus.MPI_SOURCE(), iStatus.MPI_TAG(), 0);
        if (this.datatype.getBaseType() == 11) {
            Comm.Object_Deserialize(this.recvBuffer, (byte[])object, this.offset, this.count, this.datatype);
            n = 1;
        } else {
            n = this.copyBufferCheck(object, 0, this.recvBuffer, this.offset, this.count, this.datatype);
        }
        status.setLength(n);
        this.msgHandle.removeDataFromBuffer(status.source, this.dst, status.tag);
        return status;
    }

    public Status Test() {
        Status status = null;
        IStatus iStatus = new IStatus(this.src, this.tag, this.count);
        Object object = this.msgHandle.getDataFromBuffer(this.src, this.dst, this.tag, iStatus);
        if (object != null) {
            byte[] byArray = (byte[])object;
            int n = byArray.length;
            status = new Status(iStatus.MPI_SOURCE(), iStatus.MPI_TAG(), n);
        }
        return status;
    }

    private int copyBufferCheck(Object object, int n, Object object2, int n2, int n3, Datatype datatype) {
        int n4 = datatype.getDisplacementSequence().length;
        switch (datatype.getBaseType()) {
            case 10: {
                String[] stringArray = (String[])object;
                String[] stringArray2 = (String[])object2;
                if (stringArray.length > n3) {
                    System.out.println("** [Error] sending message size is bigger than recieving message size");
                    System.exit(1);
                } else {
                    n3 = stringArray.length;
                }
                for (int i = 0; i < n3; ++i) {
                    stringArray2[i] = stringArray[i];
                }
                break;
            }
            case 1: {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = (byte[])object2;
                if (byArray.length > n4 * n3) {
                    System.out.println("** [Error] sending message size is bigger than recieving message size");
                    System.exit(1);
                } else {
                    n3 = byArray.length;
                }
                System.arraycopy(byArray, n, byArray2, n2, n3);
                break;
            }
            case 2: {
                char[] cArray = (char[])object;
                char[] cArray2 = (char[])object2;
                if (cArray.length > n4 * n3) {
                    System.out.println("** [Error] sending message size is bigger than recieving message size");
                    System.exit(1);
                } else {
                    n3 = cArray.length;
                }
                System.arraycopy(cArray, n, cArray2, n2, n3);
                break;
            }
            case 3: {
                short[] sArray = (short[])object;
                short[] sArray2 = (short[])object2;
                if (sArray.length > n4 * n3) {
                    System.out.println("** [Error] sending message size is bigger than recieving message size");
                    System.exit(1);
                } else {
                    n3 = sArray.length;
                }
                System.arraycopy(sArray, n, sArray2, n2, n3);
                break;
            }
            case 5: {
                int[] nArray = (int[])object;
                int[] nArray2 = (int[])object2;
                if (nArray.length > n4 * n3) {
                    System.out.println("** [Error] sending message size is bigger than recieving message size");
                    System.exit(1);
                } else {
                    n3 = nArray.length;
                }
                System.arraycopy(nArray, n, nArray2, n2, n3);
                break;
            }
            case 6: {
                long[] lArray = (long[])object;
                long[] lArray2 = (long[])object2;
                if (lArray.length > n4 * n3) {
                    System.out.println("** [Error] sending message size is bigger than recieving message size");
                    System.exit(1);
                } else {
                    n3 = lArray.length;
                }
                System.arraycopy(lArray, n, lArray2, n2, n3);
                break;
            }
            case 7: {
                float[] fArray = (float[])object;
                float[] fArray2 = (float[])object2;
                if (fArray.length > n4 * n3) {
                    System.out.println("** [Error] sending message size is bigger than recieving message size");
                    System.exit(1);
                } else {
                    n3 = fArray.length;
                }
                System.arraycopy(fArray, n, fArray2, n2, n3);
                break;
            }
            case 8: {
                double[] dArray = (double[])object;
                double[] dArray2 = (double[])object2;
                if (dArray.length > n4 * n3) {
                    System.out.println("** [Error] sending message size is bigger than recieving message size");
                    System.exit(1);
                } else {
                    n3 = dArray.length;
                }
                System.arraycopy(dArray, n, dArray2, n2, n3);
            }
        }
        return n3 * datatype.getBaseSize();
    }
}

