/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Properties;
import java.util.Vector;
import p2pmpi.common.GossipConfig;
import p2pmpi.common.MapRankTable;
import p2pmpi.common.RankTable;
import p2pmpi.message.DataMessage;
import p2pmpi.message.UpdateStatusMessage;
import p2pmpi.mpi.Datatype;
import p2pmpi.mpi.Group;
import p2pmpi.mpi.MPI;
import p2pmpi.mpi.Request;
import p2pmpi.mpi.Status;
import p2pmpi.mpi.internal.IStatus;
import p2pmpi.mpi.internal.MessageHandler;
import p2pmpi.mpi.internal.MessageIDLog;
import p2pmpi.mpi.internal.SendBufferInformation;

public class Comm {
    private static int globalCommID = 0;
    private MessageHandler msgHandle;
    protected int commID;
    protected Group myGroup;
    protected MapRankTable mapRankTable;
    protected Properties midLog = new Properties();
    private int numReplica;
    private int[] myReplica;
    private static int MAX_REPLICA = 256;
    private int numProc;
    private int waitingTime;
    private MessageIDLog sendLog;
    private Vector<SendBufferInformation> backupMessage;

    public Comm(MessageHandler messageHandler, RankTable rankTable, int n, int n2, int n3, MapRankTable mapRankTable) {
        int n4;
        int n5;
        this.sendLog = new MessageIDLog();
        this.backupMessage = new Vector();
        this.msgHandle = messageHandler;
        this.msgHandle.setSendBackupAndLog(this.backupMessage, this.sendLog);
        this.myGroup = new Group(messageHandler, rankTable, n, n2, n3, this.backupMessage, this.sendLog, mapRankTable);
        this.commID = globalCommID++;
        this.myReplica = new int[MAX_REPLICA];
        RankTable rankTable2 = this.myGroup.__getCommTable();
        MapRankTable mapRankTable2 = this.myGroup.__getMapCommTable();
        this.numProc = mapRankTable2.size();
        int n6 = this.myGroup.Rank();
        for (n5 = 0; n5 < this.numProc; ++n5) {
            n4 = mapRankTable2.getRankInList(n5);
            if (!rankTable2.isAlive(n4) || n6 != mapRankTable2.getRank(n5)) continue;
            this.myReplica[this.numReplica] = n5;
            ++this.numReplica;
        }
        n5 = this.myGroup.RankInList();
        n4 = 1;
        int n7 = n5;
        for (int i = 0; i < this.numReplica; ++i) {
            int n8 = mapRankTable2.getRankInList(this.myReplica[i]);
            if (!rankTable2.isAlive(n8)) continue;
            if (n5 > this.myReplica[i]) {
                n4 = 0;
            }
            if (n7 <= this.myReplica[i]) continue;
            n7 = this.myReplica[i];
        }
        messageHandler.setMaster(n4 != 0);
        messageHandler.setMyMaster(n7);
        this.waitingTime = ((int)(Math.log(this.numProc) / Math.log(2.0)) * 2 + GossipConfig.margin) * GossipConfig.t_period * 2;
    }

    public Comm(Group group) {
        int n;
        int n2;
        this.myGroup = group;
        this.msgHandle = group.__getMessageHandler();
        this.commID = globalCommID++;
        this.myReplica = new int[MAX_REPLICA];
        RankTable rankTable = this.myGroup.__getCommTable();
        MapRankTable mapRankTable = this.myGroup.__getMapCommTable();
        this.numProc = mapRankTable.size();
        int n3 = this.myGroup.Rank();
        for (n2 = 0; n2 < this.numProc; ++n2) {
            n = mapRankTable.getRankInList(n2);
            if (!rankTable.isAlive(n) || n3 != mapRankTable.getRank(n2)) continue;
            this.myReplica[this.numReplica] = n2;
            ++this.numReplica;
        }
        n2 = this.myGroup.RankInList();
        n = 1;
        int n4 = n2;
        for (int i = 0; i < this.numReplica; ++i) {
            int n5 = mapRankTable.getRankInList(this.myReplica[i]);
            if (!rankTable.isAlive(n5)) continue;
            if (n2 > this.myReplica[i]) {
                n = 0;
            }
            if (n4 <= this.myReplica[i]) continue;
            n4 = this.myReplica[i];
        }
        this.msgHandle.setMaster(n != 0);
        this.msgHandle.setMyMaster(n4);
        this.sendLog = this.myGroup.__getLog();
        this.backupMessage = this.myGroup.__getBackupMessage();
        this.waitingTime = ((int)(Math.log(this.numProc) / Math.log(2.0)) * 2 + GossipConfig.margin) * GossipConfig.t_period * 2;
    }

    public Group Group() {
        return this.myGroup;
    }

    public int Size() {
        return this.myGroup.Size();
    }

    public int SizeTotal() {
        return this.myGroup.__sizetotal();
    }

    public int Rank() {
        return this.myGroup.Rank();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int Send(Object object, int n, int n2, Datatype datatype, int n3, int n4) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        int n5;
        Object object7;
        Object object8;
        Object object9;
        if (this.Rank() == MPI.UNDEFINED) {
            return -1;
        }
        String string = this.getMessageID(this.Rank(), n3, n4);
        int n6 = datatype.getBaseType();
        int n7 = datatype.getDisplacementSequence().length;
        DataMessage dataMessage = new DataMessage(string, this.Rank(), n3, n4);
        switch (n6) {
            case 11: {
                object9 = Comm.Object_Serialize(object, n, n2, datatype);
                dataMessage.addData((byte[])object9);
                break;
            }
            case 10: {
                object8 = (String[])object;
                object7 = new String[n7 * n2];
                for (n5 = 0; n5 < n7 * n2; ++n5) {
                    object7[n5] = new String((String)object8[n5]);
                }
                dataMessage.addData((String[])object7);
                break;
            }
            case 1: {
                byte[] byArray = (byte[])object;
                object6 = new byte[n7 * n2];
                System.arraycopy(byArray, n, object6, 0, n7 * n2);
                dataMessage.addData((byte[])object6);
                break;
            }
            case 2: {
                object5 = (char[])object;
                object4 = new char[n7 * n2];
                System.arraycopy(object5, n, object4, 0, n7 * n2);
                dataMessage.addData((char[])object4);
                break;
            }
            case 3: {
                short[] sArray = (short[])object;
                short[] sArray2 = new short[n7 * n2];
                System.arraycopy(sArray, n, sArray2, 0, n7 * n2);
                dataMessage.addData(sArray2);
                break;
            }
            case 5: {
                int[] nArray = (int[])object;
                int[] nArray2 = new int[n7 * n2];
                System.arraycopy(nArray, n, nArray2, 0, n7 * n2);
                dataMessage.addData(nArray2);
                break;
            }
            case 6: {
                long[] lArray = (long[])object;
                long[] lArray2 = new long[n7 * n2];
                System.arraycopy(lArray, n, lArray2, 0, n7 * n2);
                dataMessage.addData(lArray2);
                break;
            }
            case 7: {
                object3 = (float[])object;
                float[] fArray = new float[n7 * n2];
                System.arraycopy(object3, n, fArray, 0, n7 * n2);
                dataMessage.addData(fArray);
                break;
            }
            case 8: {
                object2 = (double[])object;
                double[] dArray = new double[n7 * n2];
                System.arraycopy(object2, n, dArray, 0, n7 * n2);
                dataMessage.addData(dArray);
            }
        }
        if (this.msgHandle.isMaster()) {
            object9 = this.myGroup.__getCommTable();
            object8 = this.myGroup.__getMapCommTable();
            object7 = ((MapRankTable)object8).getRankInListByRank(n3);
            n5 = ((Vector)object7).size();
            block26: for (int i = 0; i < n5; ++i) {
                int n8 = (Integer)((Vector)object7).elementAt(i);
                long l = System.currentTimeMillis();
                while (((RankTable)object9).isAlive(n8)) {
                    try {
                        object6 = new Socket();
                        object3 = new InetSocketAddress(((RankTable)object9).getHost(n8), ((RankTable)object9).getPort(n8));
                        ((Socket)object6).connect((SocketAddress)object3, 1000);
                        object5 = ((Socket)object6).getOutputStream();
                        object4 = new ObjectOutputStream((OutputStream)object5);
                        ((ObjectOutputStream)object4).writeObject(dataMessage);
                        ((ObjectOutputStream)object4).flush();
                        ((ObjectOutputStream)object4).close();
                        ((OutputStream)object5).close();
                        ((Socket)object6).close();
                        continue block26;
                    }
                    catch (Exception exception) {
                        long l2 = System.currentTimeMillis();
                        if ((int)(l2 - l) < this.waitingTime) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Exception exception2) {}
                            continue;
                        }
                        System.out.println("[Error] some part of your system are behind firewall");
                        System.exit(1);
                    }
                }
            }
            UpdateStatusMessage updateStatusMessage = new UpdateStatusMessage(string);
            block28: for (int i = 0; i < this.numReplica; ++i) {
                int n9 = this.myReplica[i];
                int n10 = ((MapRankTable)object8).getRankInList(this.myReplica[i]);
                if (n9 == this.myGroup.RankInList()) continue;
                long l = System.currentTimeMillis();
                while (((RankTable)object9).isAlive(n10)) {
                    try {
                        object6 = new Socket();
                        object2 = new InetSocketAddress(((RankTable)object9).getHost(n10), ((RankTable)object9).getPort(n10));
                        ((Socket)object6).connect((SocketAddress)object2, 1000);
                        object5 = ((Socket)object6).getOutputStream();
                        object4 = new ObjectOutputStream((OutputStream)object5);
                        ((ObjectOutputStream)object4).writeObject(updateStatusMessage);
                        ((ObjectOutputStream)object4).flush();
                        ((ObjectOutputStream)object4).close();
                        ((OutputStream)object5).close();
                        ((Socket)object6).close();
                        continue block28;
                    }
                    catch (Exception exception) {
                        long l3 = System.currentTimeMillis();
                        if ((int)(l3 - l) < this.waitingTime) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Exception exception3) {}
                            continue;
                        }
                        System.out.println("[Error] some part of your system are behind firewall");
                        System.exit(1);
                    }
                }
            }
        } else {
            object8 = this.sendLog;
            synchronized (object8) {
                int n11 = this.sendLog.isExist(string);
                if (n11 != -1) {
                    this.sendLog.remove(string);
                } else {
                    this.sendLog.add(string);
                    object7 = new SendBufferInformation(string, this.Rank(), n3, dataMessage, n4);
                    Vector<SendBufferInformation> vector = this.backupMessage;
                    synchronized (vector) {
                        this.backupMessage.addElement((SendBufferInformation)object7);
                    }
                }
            }
        }
        return n2;
    }

    public Request IRecv(Object object, int n, int n2, Datatype datatype, int n3, int n4) {
        if (this.Rank() == MPI.UNDEFINED) {
            return null;
        }
        Request request = new Request(this.msgHandle, object, n, n2, datatype, n3, n4, this.Rank());
        return request;
    }

    public Status Sendrecv(Object object, int n, int n2, Datatype datatype, int n3, int n4, Object object2, int n5, int n6, Datatype datatype2, int n7, int n8) {
        Request request = this.IRecv(object2, n5, n6, datatype2, n7, n8);
        this.Send(object, n, n2, datatype, n3, n4);
        return request.Wait();
    }

    public Status Recv(Object object, int n, int n2, Datatype datatype, int n3, int n4) {
        int n5;
        Object object2;
        if (this.Rank() == MPI.UNDEFINED) {
            return null;
        }
        IStatus iStatus = new IStatus();
        Status status = null;
        while ((object2 = this.msgHandle.getDataFromBuffer(n3, this.Rank(), n4, iStatus)) == null) {
        }
        status = new Status(iStatus.MPI_SOURCE(), iStatus.MPI_TAG(), 0);
        int n6 = datatype.getBaseType();
        if (n6 == 11) {
            Comm.Object_Deserialize(object, (byte[])object2, n, n2, datatype);
            n5 = 1;
        } else {
            int n7 = datatype.getDisplacementSequence().length;
            n5 = this.copyBufferCheck(object2, 0, object, n, n7 * n2, datatype);
        }
        status.setLength(n5);
        this.msgHandle.removeDataFromBuffer(n3, this.Rank(), n4);
        return status;
    }

    private String getMessageID(int n, int n2, int n3) {
        int n4;
        String string = n + "_" + n2 + "_" + n3;
        String string2 = this.midLog.getProperty(string);
        if (string2 == null) {
            n4 = 0;
            this.midLog.setProperty(string, "1");
        } else {
            n4 = Integer.parseInt(string2);
            this.midLog.remove(string);
            this.midLog.setProperty(string, Integer.toString(n4 + 1));
        }
        return this.commID + "_" + string + "_" + n4;
    }

    protected int copyBuffer(Object object, int n, Object object2, int n2, int n3, Datatype datatype) {
        int n4 = datatype.getDisplacementSequence().length;
        switch (datatype.getBaseType()) {
            case 10: {
                String[] stringArray = (String[])object;
                String[] stringArray2 = (String[])object2;
                for (int i = 0; i < n3; ++i) {
                    stringArray2[i] = stringArray[i];
                }
                break;
            }
            case 1: {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = (byte[])object2;
                System.arraycopy(byArray, n, byArray2, n2, n4 * n3);
                break;
            }
            case 2: {
                char[] cArray = (char[])object;
                char[] cArray2 = (char[])object2;
                System.arraycopy(cArray, n, cArray2, n2, n4 * n3);
                break;
            }
            case 3: {
                short[] sArray = (short[])object;
                short[] sArray2 = (short[])object2;
                System.arraycopy(sArray, n, sArray2, n2, n4 * n3);
                break;
            }
            case 5: {
                int[] nArray = (int[])object;
                int[] nArray2 = (int[])object2;
                System.arraycopy(nArray, n, nArray2, n2, n4 * n3);
                break;
            }
            case 6: {
                long[] lArray = (long[])object;
                long[] lArray2 = (long[])object2;
                System.arraycopy(lArray, n, lArray2, n2, n4 * n3);
                break;
            }
            case 7: {
                float[] fArray = (float[])object;
                float[] fArray2 = (float[])object2;
                System.arraycopy(fArray, n, fArray2, n2, n4 * n3);
                break;
            }
            case 8: {
                double[] dArray = (double[])object;
                double[] dArray2 = (double[])object2;
                System.arraycopy(dArray, n, dArray2, n2, n4 * n3);
            }
        }
        return n3 * datatype.getBaseSize();
    }

    protected int copyBufferCheck(Object object, int n, Object object2, int n2, int n3, Datatype datatype) {
        int n4 = datatype.getDisplacementSequence().length;
        switch (datatype.getBaseType()) {
            case 10: {
                String[] stringArray = (String[])object;
                String[] stringArray2 = (String[])object2;
                if (stringArray.length > n3) {
                    System.out.println("** [Error]: sending message size(" + stringArray.length + ") is bigger than receiving message size(" + n3 + ")");
                    System.exit(1);
                } else {
                    n3 = stringArray.length;
                }
                for (int i = 0; i < n3; ++i) {
                    stringArray2[i] = stringArray[i];
                }
                break;
            }
            case 1: {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = (byte[])object2;
                if (byArray.length > n4 * n3) {
                    System.out.println("** [Error]: sending message size is bigger than receiving message size");
                    System.exit(1);
                } else {
                    n3 = byArray.length;
                }
                System.arraycopy(byArray, n, byArray2, n2, n3);
                break;
            }
            case 2: {
                char[] cArray = (char[])object;
                char[] cArray2 = (char[])object2;
                if (cArray.length > n4 * n3) {
                    System.out.println("** [Error]: sending message size(" + cArray.length + ") is bigger than receiving message size(" + n3 + ")");
                    System.exit(1);
                } else {
                    n3 = cArray.length;
                }
                System.arraycopy(cArray, n, cArray2, n2, n3);
                break;
            }
            case 3: {
                short[] sArray = (short[])object;
                short[] sArray2 = (short[])object2;
                if (sArray.length > n4 * n3) {
                    System.out.println("** [Error]: sending message size(" + sArray.length + ") is bigger than receiving message size(" + n3 + ")");
                    System.exit(1);
                } else {
                    n3 = sArray.length;
                }
                System.arraycopy(sArray, n, sArray2, n2, n3);
                break;
            }
            case 5: {
                int[] nArray = (int[])object;
                int[] nArray2 = (int[])object2;
                if (nArray.length > n4 * n3) {
                    System.out.println("** [Error]: sending message size(" + nArray.length + ") is bigger than receiving message size(" + n3 + ")");
                    System.exit(1);
                } else {
                    n3 = nArray.length;
                }
                System.arraycopy(nArray, n, nArray2, n2, n3);
                break;
            }
            case 6: {
                long[] lArray = (long[])object;
                long[] lArray2 = (long[])object2;
                if (lArray.length > n4 * n3) {
                    System.out.println("** [Error]: sending message size(" + lArray.length + ") is bigger than receiving message size(" + n3 + ")");
                    System.exit(1);
                } else {
                    n3 = lArray.length;
                }
                System.arraycopy(lArray, n, lArray2, n2, n3);
                break;
            }
            case 7: {
                float[] fArray = (float[])object;
                float[] fArray2 = (float[])object2;
                if (fArray.length > n4 * n3) {
                    System.out.println("** [Error]: sending message size(" + fArray.length + ") is bigger than receiving message size(" + n3 + ")");
                    System.exit(1);
                } else {
                    n3 = fArray.length;
                }
                System.arraycopy(fArray, n, fArray2, n2, n3);
                break;
            }
            case 8: {
                double[] dArray = (double[])object;
                double[] dArray2 = (double[])object2;
                if (dArray.length > n4 * n3) {
                    System.out.println("** [Error]: sending message size(" + dArray.length + ") is bigger than receiving message size(" + n3 + ")");
                    System.exit(1);
                } else {
                    n3 = dArray.length;
                }
                System.arraycopy(dArray, n, dArray2, n2, n3);
            }
        }
        return n3 * datatype.getBaseSize();
    }

    public static byte[] Object_Serialize(Object object, int n, int n2, Datatype datatype) {
        if (datatype.baseType == 11) {
            byte[] byArray;
            Object[] objectArray = (Object[])object;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                for (int i = 0; i < n2; ++i) {
                    objectOutputStream.writeObject(objectArray[n + i]);
                    objectOutputStream.flush();
                }
                objectOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                byArray = null;
            }
            return byArray;
        }
        return null;
    }

    public static void Object_Deserialize(Object object, byte[] byArray, int n, int n2, Datatype datatype) {
        if (datatype.baseType == 11) {
            Object[] objectArray = (Object[])object;
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                for (int i = 0; i < n2; ++i) {
                    objectArray[n + i] = objectInputStream.readObject();
                }
                objectInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

