/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.exception.PeerGroupException;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.socket.JxtaServerSocket;
import net.jxta.socket.JxtaSocket;
import org.apache.log4j.Logger;
import p2pmpi.common.NameGenerator;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.common.P2PMPI_Messenger;
import p2pmpi.common.ProcessInfo;
import p2pmpi.common.ProcessTable;
import p2pmpi.common.Version;
import p2pmpi.message.MPDMessage;
import p2pmpi.message.PingReplyMessage;
import p2pmpi.message.PingRequestMessage;
import p2pmpi.message.StatInfoMessage;
import p2pmpi.message.StatQueryMessage;
import p2pmpi.mpd.AppInfo;
import p2pmpi.mpd.MPDAdv;
import p2pmpi.mpd.MPD_Interface;
import p2pmpi.mpd.P2PMPI_MPDPeer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2PMPI_MPD
extends P2PMPI_MPDPeer {
    int jxtaMinPort;
    int jxtaMaxPort;
    int jxtaCurrentPort;
    int ftPort;
    int fdPort;
    String externalIP;
    String hostDeny;
    String hostAllow;
    Properties confProps;
    Hashtable<String, AppInfo> hashTable;
    long startBOOT = System.currentTimeMillis();
    long stopBOOT;
    protected ProcessTable procTab = null;
    String p2pMpiPrivate = null;

    public P2PMPI_MPD(int n, int n2, int n3, int n4, int n5, String string, Properties properties, String string2, String string3, String string4) {
        this.mpdPort = n;
        this.fdPort = n2;
        this.ftPort = n3;
        this.jxtaMinPort = n4;
        this.jxtaMaxPort = n5;
        this.confProps = properties;
        this.externalIP = string2;
        this.hostDeny = string3;
        this.hostAllow = string4;
        this.jxtaCurrentPort = n4;
        this.tmpDir = new String(string);
        this.procTab = new ProcessTable();
        this.p2pMpiPrivate = System.getProperty("P2P_MPI_PRIVATE");
        this.hashTable = new Hashtable();
        log = Logger.getLogger((String)"MPD");
        log.info((Object)"Starting MPD");
    }

    protected synchronized String getUniquePeerName(String string) {
        return new String(NameGenerator.getUniqueName(string));
    }

    protected synchronized int getJxtaPort() {
        ServerSocket serverSocket = null;
        for (int i = 0; i < 2; ++i) {
            for (int j = this.jxtaCurrentPort; j <= this.jxtaMaxPort; ++j) {
                try {
                    serverSocket = new ServerSocket(j);
                    serverSocket.close();
                    this.jxtaCurrentPort = j + 1;
                    return j;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            this.jxtaCurrentPort = this.jxtaMinPort;
        }
        return -1;
    }

    protected synchronized void requestPeer(PipeAdvertisement pipeAdvertisement, MPDMessage mPDMessage) {
        try {
            log.debug((Object)"--------Call REQUEST PEER WORKER-----------");
            log.debug((Object)pipeAdvertisement.toString());
            log.debug((Object)"-------------------------------------------");
            P2PMPI_Messenger p2PMPI_Messenger = new P2PMPI_Messenger(this.mpipg, pipeAdvertisement, mPDMessage, 5);
            p2PMPI_Messenger.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean isPeerOnline(PipeAdvertisement pipeAdvertisement) {
        int n = 5;
        JxtaSocket jxtaSocket = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        PingRequestMessage pingRequestMessage = new PingRequestMessage();
        while (n-- > 0) {
            try {
                jxtaSocket = new JxtaSocket(this.mpipg, null, pipeAdvertisement, 2000, true);
                outputStream = jxtaSocket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(pingRequestMessage);
                objectOutputStream.flush();
                inputStream = jxtaSocket.getInputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                Object object = objectInputStream.readObject();
                if (!(object instanceof PingReplyMessage)) continue;
                return true;
            }
            catch (Exception exception) {
                log.debug((Object)exception.toString());
            }
        }
        return false;
    }

    protected Vector<PipeAdvertisement> searchMPD(int n, int n2, int n3) {
        long l;
        int n4 = 0;
        int n5 = 10;
        Vector<PipeAdvertisement> vector = new Vector<PipeAdvertisement>();
        log.info((Object)("Searching For Advertisements [Min = " + n + ", Max = " + n2 + ", Wait = " + n3 + "]"));
        long l2 = System.currentTimeMillis();
        do {
            try {
                n4 = 0;
                Enumeration enumeration = this.discovery.getLocalAdvertisements(2, "Name", "P2P-MPI:MPD2" + Version.MAINVERSION + "*");
                if (enumeration != null && enumeration.hasMoreElements()) {
                    vector.removeAllElements();
                    while (enumeration.hasMoreElements()) {
                        PipeAdvertisement pipeAdvertisement = (PipeAdvertisement)enumeration.nextElement();
                        if (!this.isPeerOnline(pipeAdvertisement)) continue;
                        if (!pipeAdvertisement.getName().equals(this.pipeAdv.getName())) {
                            vector.addElement(pipeAdvertisement);
                            ++n4;
                        }
                        if (n4 < n2) continue;
                        return vector;
                    }
                    vector.addElement(this.pipeAdv);
                    if (++n4 >= n2) {
                        return vector;
                    }
                }
                log.debug((Object)("Found>" + n4 + " ads"));
                this.discovery.getRemoteAdvertisements(null, 2, "Name", "P2P-MPI:MPD2" + Version.MAINVERSION + "*", n2 + n5, null);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } while ((int)(((l = System.currentTimeMillis()) - l2) / 1000L) <= n3);
        return vector;
    }

    @Override
    public void run() {
        String string = System.getProperty("user.name");
        if (string == null) {
            string = "noname";
        }
        this.peerName = NameGenerator.getUniqueName("P2P-MPD");
        int n = this.getJxtaPort();
        if (!this.createJXTAPlatform(n, this.confProps)) {
            log.fatal((Object)"Fatal Error: Can't create JXTA Platform");
            return;
        }
        System.setProperty("JXTA_HOME", this.runPath.toString());
        log.info((Object)"Creating netPG");
        try {
            this.netpg = PeerGroupFactory.newNetPeerGroup();
        }
        catch (PeerGroupException peerGroupException) {
            peerGroupException.printStackTrace();
            return;
        }
        this.joinMpiGroup(10, 500, true, 60, 1000, true);
        if (!this.createPipe(this.mpipg, "MPD2" + Version.MAINVERSION + "." + Version.SUBVERSION, true)) {
            log.fatal((Object)"MPD Pipe Creation failed");
            return;
        }
        log.debug((Object)"============= Pipe Adv ==================");
        log.debug((Object)this.pipeAdv.toString());
        log.debug((Object)"=========================================");
        log.info((Object)">>> Creating MPD advertisement.");
        MPDAdv mPDAdv = this.createMPDAdv(this.mpipg);
        DiscoveryService discoveryService = this.mpipg.getDiscoveryService();
        try {
            discoveryService.publish((Advertisement)mPDAdv);
            discoveryService.remotePublish((Advertisement)mPDAdv);
        }
        catch (IOException iOException) {
            log.info((Object)iOException.toString());
        }
        log.debug((Object)mPDAdv.toString());
        MPD_Interface mPD_Interface = new MPD_Interface(this);
        mPD_Interface.start();
        log.info((Object)"MPD is Ready");
        this.requestListenerSocket = null;
        Socket socket = null;
        try {
            this.requestListenerSocket = new JxtaServerSocket(this.mpipg, this.pipeAdv, 50);
            this.requestListenerSocket.setSoTimeout(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        this.stopBOOT = System.currentTimeMillis();
        log.debug((Object)("BOOT TIME = " + (this.stopBOOT - this.startBOOT)));
        while (true) {
            try {
                log.debug((Object)"Waiting for a request");
                socket = this.requestListenerSocket.accept();
                P2PMPI_MPDThread p2PMPI_MPDThread = new P2PMPI_MPDThread(socket);
                p2PMPI_MPDThread.start();
            }
            catch (Exception exception) {
                break;
            }
            System.gc();
        }
    }

    public static void main(String[] stringArray) {
        File file = new File(System.getProperty("P2PMPI_HOME"), "P2P-MPI.conf");
        File file2 = new File(System.getProperty("P2PMPI_HOME"), "tmp");
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile(file.toString());
        P2PMPI_MPD p2PMPI_MPD = new P2PMPI_MPD(p2PMPI_ConfigFile.getMPDPort(), p2PMPI_ConfigFile.getFDPort(), p2PMPI_ConfigFile.getFTPort(), p2PMPI_ConfigFile.getMinPort(), p2PMPI_ConfigFile.getMaxPort(), file2.toString(), p2PMPI_ConfigFile.getProperties(), p2PMPI_ConfigFile.getExternalIP(), p2PMPI_ConfigFile.getHostDeny(), p2PMPI_ConfigFile.getHostAllow());
        p2PMPI_MPD.start();
    }

    public class P2PMPI_MPDThread
    extends Thread {
        Socket jxtaSocket = null;

        public P2PMPI_MPDThread(Socket socket) {
            this.jxtaSocket = socket;
        }

        private boolean isAllowed(String string, String string2) {
            URI uRI = null;
            if (string2 != null) {
                try {
                    P2PMPI_MPDPeer.log.info((Object)("Checking against " + string2));
                    uRI = new URI(string2);
                }
                catch (URISyntaxException uRISyntaxException) {
                    P2PMPI_MPDPeer.log.info((Object)(" [Error] " + string2 + " is not valid in configuration file."));
                    return true;
                }
                if (string != uRI.getHost()) {
                    P2PMPI_MPDPeer.log.info((Object)(" [Denied] " + string + " is not allowed (from configuration file)."));
                    P2PMPI_MPDPeer.log.info((Object)"==============================================");
                    return false;
                }
                return true;
            }
            return true;
        }

        public void run() {
            Object object;
            InputStream inputStream = null;
            OutputStream outputStream = null;
            ObjectInputStream objectInputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                inputStream = this.jxtaSocket.getInputStream();
                outputStream = this.jxtaSocket.getOutputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                object = objectInputStream.readObject();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            if (object instanceof MPDMessage) {
                MPDMessage mPDMessage = (MPDMessage)object;
                switch (mPDMessage.getCmd()) {
                    case 8: {
                        Object object2;
                        try {
                            objectInputStream.close();
                            inputStream.close();
                            this.jxtaSocket.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        URI uRI = mPDMessage.getIP();
                        String string = mPDMessage.getID();
                        String string2 = mPDMessage.getRunCmd();
                        int n = mPDMessage.getRank();
                        MPDMessage mPDMessage2 = null;
                        P2PMPI_MPDPeer.log.info((Object)"======= I have a peer request message =======");
                        if (!this.isAllowed(uRI.getHost(), P2PMPI_MPD.this.hostDeny)) {
                            mPDMessage2 = new MPDMessage(10, string);
                        } else {
                            P2PMPI_MPDPeer.log.info((Object)(" ID     = " + string));
                            P2PMPI_MPDPeer.log.info((Object)(" myRank = " + n));
                            P2PMPI_MPDPeer.log.info((Object)(" URI    = " + uRI.getHost() + ":" + uRI.getPort()));
                            P2PMPI_MPDPeer.log.info((Object)(" runCmd = " + string2));
                            P2PMPI_MPDPeer.log.info((Object)"==============================================");
                            AppInfo appInfo = new AppInfo();
                            appInfo.setRunCmd(string2);
                            appInfo.setRank0(uRI);
                            object2 = string + "--" + n;
                            P2PMPI_MPD.this.hashTable.put((String)object2, appInfo);
                            mPDMessage2 = new MPDMessage(9, string);
                            mPDMessage2.setFTPort(P2PMPI_MPD.this.ftPort);
                            mPDMessage2.setFDPort(P2PMPI_MPD.this.fdPort);
                            mPDMessage2.setRank(n);
                        }
                        if (P2PMPI_MPD.this.externalIP == null) {
                            object2 = null;
                            try {
                                object2 = InetAddress.getLocalHost();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            mPDMessage2.setMyHost(((InetAddress)object2).getHostAddress());
                        } else {
                            mPDMessage2.setMyHost(P2PMPI_MPD.this.externalIP);
                        }
                        object2 = null;
                        try {
                            object2 = new Socket(uRI.getHost(), uRI.getPort());
                            outputStream = ((Socket)object2).getOutputStream();
                            objectOutputStream = new ObjectOutputStream(outputStream);
                            objectOutputStream.writeObject(mPDMessage2);
                            objectOutputStream.flush();
                            objectOutputStream.close();
                            outputStream.close();
                            ((Socket)object2).close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break;
                    }
                    default: {
                        try {
                            objectInputStream.close();
                            inputStream.close();
                            this.jxtaSocket.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break;
                    }
                }
            } else if (object instanceof PingRequestMessage) {
                PingReplyMessage pingReplyMessage = new PingReplyMessage();
                try {
                    P2PMPI_MPDPeer.log.debug((Object)"PingRequest : receive ping request message");
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(pingReplyMessage);
                    P2PMPI_MPDPeer.log.debug((Object)"PingReply : send back ping reply message");
                    objectOutputStream.flush();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    objectOutputStream.close();
                    outputStream.close();
                    objectInputStream.close();
                    inputStream.close();
                    this.jxtaSocket.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (object instanceof StatQueryMessage) {
                Serializable serializable;
                StatInfoMessage statInfoMessage = new StatInfoMessage();
                Enumeration enumeration = P2PMPI_MPD.this.procTab.elements();
                while (enumeration.hasMoreElements()) {
                    serializable = (ProcessInfo)enumeration.nextElement();
                    if (((ProcessInfo)serializable).getRank() != 0) continue;
                    statInfoMessage.addInfo((ProcessInfo)serializable);
                }
                serializable = null;
                try {
                    serializable = InetAddress.getLocalHost();
                    String string = ((InetAddress)serializable).getHostName() + "/" + InetAddress.getByName(((InetAddress)serializable).getHostName()).getHostAddress();
                    statInfoMessage.setHostname(string);
                }
                catch (Exception exception) {
                    P2PMPI_MPDPeer.log.error((Object)"GAZ : Could not figure out hostname");
                    System.exit(1);
                }
                try {
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(statInfoMessage);
                    P2PMPI_MPDPeer.log.debug((Object)"GAZ : Sending visualization information ...");
                    objectOutputStream.flush();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    objectOutputStream.close();
                    outputStream.close();
                    objectInputStream.close();
                    inputStream.close();
                    this.jxtaSocket.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                try {
                    objectInputStream.close();
                    inputStream.close();
                    this.jxtaSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

