/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.message;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.net.URI;

public class FTMessage
implements Serializable {
    int cmd;
    String hashID;
    String[] fileList;
    String[] fileOnlyList;
    URI[] uriList;
    int[] keyList;
    int size;
    int key;
    byte[][] fileContent;

    public FTMessage(int n, String string) {
        this.cmd = n;
        this.hashID = string;
    }

    public void setKeys(int[] nArray) {
        this.keyList = nArray;
    }

    public void setURIs(URI[] uRIArray) {
        this.uriList = uRIArray;
    }

    public void setFileNames(String[] stringArray) {
        this.fileList = stringArray;
        int n = this.fileList.length;
        this.fileOnlyList = new String[n];
        for (int i = 0; i < n; ++i) {
            File file = new File(this.fileList[i]);
            this.fileOnlyList[i] = file.getName();
        }
    }

    public void setFileContent(String[] stringArray) {
        this.fileContent = new byte[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            int n = (int)file.length();
            try {
                this.fileContent[i] = new byte[n];
                FileInputStream fileInputStream = new FileInputStream(stringArray[i]);
                fileInputStream.read(this.fileContent[i], 0, n);
                fileInputStream.close();
                continue;
            }
            catch (Exception exception) {
                System.err.println("**[MPI info] Error while processing file " + stringArray[i]);
                exception.printStackTrace();
            }
        }
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getCmd() {
        return this.cmd;
    }

    public String getID() {
        return this.hashID;
    }

    public int getKey(int n) {
        return this.keyList[n];
    }

    public URI getURI(int n) {
        return this.uriList[n];
    }

    public int size() {
        return this.size;
    }

    public String[] getFileNameList() {
        return this.fileList;
    }

    public String[] getOnlyFileNameList() {
        return this.fileOnlyList;
    }

    public String getFileName(int n) {
        return this.fileList[n];
    }

    public byte[] getFileContent(int n) {
        return this.fileContent[n];
    }

    public int getNumFile() {
        return this.fileList.length;
    }

    public void setKey(int n) {
        this.key = n;
    }

    public int getKey() {
        return this.key;
    }
}

