/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Properties;
import net.jxta.ext.config.Address;
import net.jxta.ext.config.Configurator;
import net.jxta.ext.config.HttpTransport;
import net.jxta.ext.config.MulticastAddress;
import net.jxta.ext.config.TcpTransport;
import net.jxta.ext.config.TcpTransportAddress;
import net.jxta.ext.config.Trace;
import net.jxta.ext.config.Transport;
import org.apache.log4j.Logger;

public class PlatformGenerator {
    private static final String TLS_PRINCIPAL_PROP = "net.jxta.tls.principal";
    private static final String TLS_PASSWORD_PROP = "net.jxta.tls.password";
    private static final String JXTA_HOME = "JXTA_HOME";
    private static String TCP_PRE = "tcp://";
    private static String UDP_PRE = "udp://";
    private static String TCPADDRESS = "0.0.0.0";
    private static final String ADDR_SEP = ":";
    private static final String USER_NAME = "ulp";
    private static final String USER_PASSWD = "strasbourg";
    private final String RendezvousIP = "Rendezvous_";
    private final String RelayIP = "Relay_";
    private String peerName = null;
    private String jxtaHome = null;
    private int jxtaPort;
    private Properties confProps = null;
    static Logger log = null;

    public PlatformGenerator(String string, String string2, int n, Properties properties) {
        this.peerName = string;
        this.jxtaHome = string2;
        this.jxtaPort = n;
        this.confProps = properties;
        log = Logger.getLogger((String)"MPD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generatePlatform() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        try {
            URI uRI;
            System.setProperty(JXTA_HOME, this.jxtaHome);
            object4 = new File(this.jxtaHome, "PlatformConfig");
            object3 = new Configurator(this.peerName, "P2P-MPI", USER_NAME, USER_PASSWD);
            object3.setRelay(false);
            object3.setRendezVous(false);
            object3.setProxy(false);
            object3.setRelayOutgoing(false);
            object3.setRelayIncoming(false);
            object3.clearTransports();
            object2 = new TcpTransportAddress();
            try {
                uRI = new URI(TCP_PRE + "0.0.0.0" + ADDR_SEP + this.jxtaPort);
                object2.setAddress(uRI);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            uRI = new MulticastAddress();
            uRI.setMulticast(true);
            object2.addMulticastAddress((MulticastAddress)uRI);
            TcpTransport tcpTransport = new TcpTransport();
            tcpTransport.setAddress((Address)object2);
            tcpTransport.setIncoming(true);
            tcpTransport.setOutgoing(true);
            tcpTransport.setProxy(false);
            tcpTransport.setEnabled(true);
            object3.setTransport((Transport)tcpTransport);
            object = new Address();
            HttpTransport httpTransport = new HttpTransport();
            httpTransport.setAddress(object);
            httpTransport.setIncoming(false);
            httpTransport.setOutgoing(false);
            httpTransport.setProxy(false);
            httpTransport.setEnabled(false);
            object3.addTransport((Transport)httpTransport);
            object3.setEndpointOutgoingQueueSize(256);
            object3.clearRendezVous();
            object3.clearRelays();
            URI uRI2 = null;
            int n = 1;
            String string = null;
            while ((string = this.confProps.getProperty("Rendezvous_" + n)) != null) {
                try {
                    uRI2 = new URI(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
                object3.addRendezVous(uRI2);
                ++n;
            }
            URI uRI3 = null;
            n = 1;
            String string2 = null;
            while ((string2 = this.confProps.getProperty("Relay_" + n)) != null) {
                try {
                    uRI3 = new URI(string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
                object3.addRelay(uRI3);
                ++n;
            }
            object3.setTrace(Trace.ERROR);
            if (object3.save((File)object4)) {
                log.info((Object)"Successful: PlatformConfig");
            } else {
                log.info((Object)"Unsuccessful : PlatformConfig");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.error((Object)exception.toString());
            return false;
        }
        object4 = null;
        object3 = null;
        try {
            log.debug((Object)("Private network Input file = " + System.getProperty("P2P_MPI_PRIVATE")));
            object4 = new FileInputStream(System.getProperty("P2P_MPI_PRIVATE")).getChannel();
            object2 = new File(this.jxtaHome, "config.properties");
            log.debug((Object)("Private network Output file = " + ((File)object2).toString()));
            object3 = new FileOutputStream((File)object2).getChannel();
            long l = ((FileChannel)object4).size();
            object = ((FileChannel)object4).map(FileChannel.MapMode.READ_ONLY, 0L, l);
            ((FileChannel)object3).write((ByteBuffer)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.error((Object)exception.toString());
        }
        finally {
            if (object4 != null) {
                try {
                    ((AbstractInterruptibleChannel)object4).close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    log.error((Object)exception.toString());
                }
            }
            if (object3 != null) {
                try {
                    ((AbstractInterruptibleChannel)object3).close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    log.error((Object)exception.toString());
                }
            }
        }
        log.debug((Object)"Done.. create private network");
        return true;
    }
}

