/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.common;

public class OsName {
    private static String[] normalizedOsCategory = new String[]{"Linux", "Windows", "Macosx", "SunOS"};

    public static String get() {
        return System.getProperty("os.name");
    }

    public static boolean equalsOs(String string, String string2) {
        String string3 = string.replaceAll(" ", "").toLowerCase();
        return string3.startsWith(string2.toLowerCase());
    }

    public static boolean isLinux(String string) {
        return OsName.equalsOs(string, normalizedOsCategory[0]);
    }

    public static boolean isWindows(String string) {
        return OsName.equalsOs(string, normalizedOsCategory[1]);
    }

    public static boolean isMacosx(String string) {
        return OsName.equalsOs(string, normalizedOsCategory[2]);
    }

    public static String normalizedOsName(String string) {
        for (int i = 0; i < normalizedOsCategory.length; ++i) {
            if (!OsName.equalsOs(string, normalizedOsCategory[i])) continue;
            return normalizedOsCategory[i];
        }
        return "Unknown";
    }

    public static void main(String[] stringArray) {
        String string = OsName.get();
        System.out.println("Exact system name as returned by  System.getProperty() : " + string);
        System.out.println("normalizedOsName(" + string + ") : " + OsName.normalizedOsName(string));
        System.out.println("normalizedOsName(Mac Os X) : " + OsName.normalizedOsName("Mac Os X"));
        System.out.println("Is Linux : " + OsName.isLinux(string));
        System.out.println("Is Windows : " + OsName.isWindows(string));
        System.out.println("Is MacOSX : " + OsName.isMacosx(string));
    }
}

