/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.visu;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.DragNodeUI;
import com.touchgraph.graphlayout.interaction.LocalityScroll;
import com.touchgraph.graphlayout.interaction.TGAbstractClickUI;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import com.touchgraph.graphlayout.interaction.TGUserInterface;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import p2pmpi.visu.PeerNode;
import p2pmpi.visu.PeerNodeHintUI;
import p2pmpi.visu.p2pNetMap;

public class PeerNavigateUI
extends TGUserInterface {
    TGPanel tgPanel;
    p2pNetMap tgLinkBrowser;
    LBNavigateMouseListener ml;
    TGAbstractDragUI hvDragUI;
    TGAbstractClickUI hvScrollToCenterUI;
    PeerNodeHintUI lbNodeHintUI;
    DragNodeUI dragNodeUI;
    TGAbstractDragUI rotateDragUI;
    LocalityScroll localityScroll;
    JPopupMenu nodePopup;
    JPopupMenu edgePopup;
    PeerNode popupNode;
    Edge popupEdge;

    public PeerNavigateUI(p2pNetMap p2pNetMap2) {
        this.tgLinkBrowser = p2pNetMap2;
        this.tgPanel = this.tgLinkBrowser.getTGPanel();
        this.localityScroll = this.tgLinkBrowser.localityScroll;
        this.hvDragUI = this.tgLinkBrowser.hvScroll.getHVDragUI();
        this.rotateDragUI = this.tgLinkBrowser.rotateScroll.getRotateDragUI();
        this.hvScrollToCenterUI = this.tgLinkBrowser.hvScroll.getHVScrollToCenterUI();
        this.dragNodeUI = new DragNodeUI(this.tgPanel);
        this.lbNodeHintUI = new PeerNodeHintUI(p2pNetMap2);
        this.ml = new LBNavigateMouseListener();
        this.setUpNodePopup();
        this.setUpEdgePopup();
    }

    public void activate() {
        this.tgPanel.addMouseListener(this.ml);
        this.lbNodeHintUI.activate();
    }

    public void deactivate() {
        this.tgPanel.removeMouseListener(this.ml);
        this.lbNodeHintUI.deactivate();
    }

    private void setUpNodePopup() {
        this.nodePopup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Expand Node");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PeerNavigateUI.this.popupNode != null) {
                    PeerNavigateUI.this.tgPanel.expandNode(PeerNavigateUI.this.popupNode);
                }
            }
        };
        jMenuItem.addActionListener(actionListener);
        this.nodePopup.add(jMenuItem);
        jMenuItem = new JMenuItem("Hide Node");
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Node node = PeerNavigateUI.this.tgPanel.getSelect();
                if (PeerNavigateUI.this.popupNode != null) {
                    // empty if block
                }
            }
        };
        jMenuItem.addActionListener(actionListener2);
        this.nodePopup.add(jMenuItem);
        jMenuItem = new JMenuItem("Select Node");
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PeerNavigateUI.this.popupNode != null) {
                    PeerNavigateUI.this.tgPanel.setSelect(PeerNavigateUI.this.popupNode);
                }
            }
        };
        jMenuItem.addActionListener(actionListener3);
        this.nodePopup.add(jMenuItem);
        this.nodePopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                PeerNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                PeerNavigateUI.this.tgPanel.setMouseOverN(null);
                PeerNavigateUI.this.tgPanel.repaint();
                PeerNavigateUI.this.lbNodeHintUI.activate();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    private void setUpEdgePopup() {
        this.edgePopup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Hide Edge");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PeerNavigateUI.this.popupEdge != null) {
                    PeerNavigateUI.this.tgPanel.hideEdge(PeerNavigateUI.this.popupEdge);
                }
            }
        };
        jMenuItem.addActionListener(actionListener);
        this.edgePopup.add(jMenuItem);
        this.edgePopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                PeerNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                PeerNavigateUI.this.tgPanel.setMouseOverE(null);
                PeerNavigateUI.this.tgPanel.repaint();
                PeerNavigateUI.this.lbNodeHintUI.activate();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    class LBNavigateMouseListener
    extends MouseAdapter {
        LBNavigateMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            PeerNode peerNode = (PeerNode)PeerNavigateUI.this.tgPanel.getMouseOverN();
            if (mouseEvent.getModifiers() == 16) {
                if (peerNode == null) {
                    PeerNavigateUI.this.hvDragUI.activate(mouseEvent);
                } else {
                    PeerNavigateUI.this.dragNodeUI.activate(mouseEvent);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            PeerNode peerNode = (PeerNode)PeerNavigateUI.this.tgPanel.getMouseOverN();
            PeerNode peerNode2 = (PeerNode)PeerNavigateUI.this.tgPanel.getSelect();
            if ((mouseEvent.getModifiers() & 0x10) != 0) {
                // empty if block
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                PeerNavigateUI.this.popupNode = (PeerNode)PeerNavigateUI.this.tgPanel.getMouseOverN();
                PeerNavigateUI.this.popupEdge = PeerNavigateUI.this.tgPanel.getMouseOverE();
                if (PeerNavigateUI.this.popupNode != null) {
                    PeerNavigateUI.this.tgPanel.setMaintainMouseOver(true);
                    PeerNavigateUI.this.lbNodeHintUI.deactivate();
                    PeerNavigateUI.this.nodePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (PeerNavigateUI.this.popupEdge != null) {
                    PeerNavigateUI.this.tgPanel.setMaintainMouseOver(true);
                    PeerNavigateUI.this.lbNodeHintUI.deactivate();
                    PeerNavigateUI.this.edgePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }
}

