/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.tools;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.common.Version;
import p2pmpi.message.StatInfoMessage;
import p2pmpi.message.StatQueryMessage;

public class MPDInfo {
    public static void main(String[] stringArray) {
        String string = System.getProperty("P2PMPI_HOME");
        if (string == null) {
            System.err.println("Please make sure that the environment variable P2PMPI_HOME is set");
            System.exit(1);
        }
        File file = new File(string, "P2P-MPI.conf");
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile(file.toString());
        int n = p2PMPI_ConfigFile.getMPDPort();
        Socket socket = null;
        try {
            socket = new Socket("127.0.0.1", n);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            StatQueryMessage statQueryMessage = new StatQueryMessage();
            objectOutputStream.writeObject(statQueryMessage);
            objectOutputStream.flush();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            StatInfoMessage statInfoMessage = (StatInfoMessage)objectInputStream.readObject();
            int n2 = statInfoMessage.size();
            if (n2 == 0) {
                System.out.println("===============================================");
                System.out.println("\tGatekeeper (mpd " + Version.MAINVERSION + "." + Version.SUBVERSION + ") ready.");
                System.out.println("\tNo application running.");
                System.out.println("===============================================");
            } else {
                System.out.println("===============================================");
                for (int i = 0; i < n2; ++i) {
                    System.out.println("Application Name : " + statInfoMessage.getInfo(i).getRunCmd());
                    System.out.println("MPI Rank   : " + statInfoMessage.getInfo(i).getRank());
                    System.out.println("Local Port : " + statInfoMessage.getInfo(i).getPort());
                    System.out.println("Rank 0 IP  : " + statInfoMessage.getInfo(i).getIPRank0());
                    System.out.println("===============================================");
                }
            }
            objectInputStream.close();
            objectOutputStream.close();
            inputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("=================================================================");
            System.out.println("  Could not connect to local gatekeeper. Have you run 'mpiboot' ?");
            System.out.println("=================================================================");
            System.exit(1);
        }
    }
}

