/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpd;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.log4j.Logger;
import p2pmpi.common.OsInfo;
import p2pmpi.common.ProcessInfo;
import p2pmpi.common.RankTable;
import p2pmpi.common.StreamGobbler;
import p2pmpi.message.AppRegisterMessage;
import p2pmpi.message.AppUnregisterMessage;
import p2pmpi.message.FoundNodeMessage;
import p2pmpi.message.MPDMessage;
import p2pmpi.message.NotifyMessage;
import p2pmpi.message.RequestQuitMessage;
import p2pmpi.message.StatInfoMessage;
import p2pmpi.message.StatQueryMessage;
import p2pmpi.mpd.AppInfo;
import p2pmpi.mpd.P2PMPI_MPD;

public class MPD_Interface
extends Thread {
    P2PMPI_MPD parent;
    Logger log = null;

    MPD_Interface(P2PMPI_MPD p2PMPI_MPD) {
        this.parent = p2PMPI_MPD;
        this.log = Logger.getLogger((String)"MPD");
    }

    public boolean recursiveRemove(File file) {
        try {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.recursiveRemove(fileArray[i]);
                    continue;
                }
                if (fileArray[i].delete()) continue;
                this.log.error((Object)("Failed: removing " + fileArray[i].toString() + "failed"));
            }
            if (!file.delete()) {
                this.log.error((Object)("Failed: removing " + file.toString() + "failed"));
                return false;
            }
        }
        catch (Exception exception) {
            this.log.debug((Object)exception.toString());
            return false;
        }
        return true;
    }

    public void run() {
        ServerSocket serverSocket = null;
        try {
            this.log.info((Object)("Listen MPD Socket at " + this.parent.mpdPort));
            serverSocket = new ServerSocket(this.parent.mpdPort);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        while (true) {
            try {
                Socket socket = serverSocket.accept();
                MPD_InterfaceThread mPD_InterfaceThread = new MPD_InterfaceThread(serverSocket, socket);
                mPD_InterfaceThread.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break;
            }
            System.gc();
        }
        try {
            serverSocket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class MPD_InterfaceThread
    extends Thread {
        ServerSocket serverSocket = null;
        Socket socket = null;
        Object oMsg;
        MPDMessage msg;
        AppRegisterMessage appRegMsg;

        MPD_InterfaceThread(ServerSocket serverSocket, Socket socket) {
            this.serverSocket = serverSocket;
            this.socket = socket;
        }

        public void run() {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            ObjectInputStream objectInputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                inputStream = this.socket.getInputStream();
                outputStream = this.socket.getOutputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                this.oMsg = objectInputStream.readObject();
            }
            catch (Exception exception) {
                return;
            }
            if (this.oMsg instanceof NotifyMessage) {
                NotifyMessage notifyMessage = (NotifyMessage)this.oMsg;
                MPD_Interface.this.log.debug((Object)"Got a notify message");
                String string = notifyMessage.getAppID();
                int n = notifyMessage.getRankInList();
                MPD_Interface.this.log.debug((Object)("Key = " + string));
                MPD_Interface.this.log.debug((Object)("DEADNODE = " + n));
                ProcessInfo processInfo = MPD_Interface.this.parent.procTab.getInfo(string);
                RankTable rankTable = processInfo.getRankTable();
                rankTable.setAlive(n, false);
                MPD_Interface.this.log.info((Object)("MPD got notify message deadnode =" + n));
            } else if (this.oMsg instanceof RequestQuitMessage) {
                RequestQuitMessage requestQuitMessage = new RequestQuitMessage();
                Enumeration enumeration = MPD_Interface.this.parent.procTab.elements();
                while (enumeration.hasMoreElements()) {
                    ProcessInfo processInfo = (ProcessInfo)enumeration.nextElement();
                    int n = processInfo.getPort();
                    int n2 = processInfo.getRank();
                    String string = processInfo.getRunDir();
                    try {
                        Socket socket = new Socket("127.0.0.1", n);
                        outputStream = socket.getOutputStream();
                        objectOutputStream = new ObjectOutputStream(outputStream);
                        objectOutputStream.writeObject(requestQuitMessage);
                        objectOutputStream.flush();
                        objectOutputStream.close();
                        outputStream.close();
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n2 == 0) continue;
                    MPD_Interface.this.recursiveRemove(new File(string));
                }
                MPD_Interface.this.parent.stopApp();
                System.gc();
                MPD_Interface.this.recursiveRemove(MPD_Interface.this.parent.runPath);
                MPD_Interface.this.log.info((Object)"Shutdown completed");
                System.exit(0);
            } else if (this.oMsg instanceof AppUnregisterMessage) {
                try {
                    objectInputStream.close();
                    inputStream.close();
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AppUnregisterMessage appUnregisterMessage = (AppUnregisterMessage)this.oMsg;
                String string = appUnregisterMessage.getKey();
                String string2 = MPD_Interface.this.parent.procTab.getRunDir(string);
                int n = MPD_Interface.this.parent.procTab.getRank(string);
                MPD_Interface.this.parent.procTab.removeProcess(string);
                if (n != 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MPD_Interface.this.recursiveRemove(new File(string2));
                }
            } else if (this.oMsg instanceof AppRegisterMessage) {
                this.appRegMsg = (AppRegisterMessage)this.oMsg;
                ProcessInfo processInfo = new ProcessInfo();
                processInfo.setID(this.appRegMsg.getID());
                processInfo.setRunCmd(this.appRegMsg.getRunCmd());
                processInfo.setIPRank0(this.appRegMsg.getIPRank0());
                processInfo.setRunDir(this.appRegMsg.getRunDir());
                processInfo.setRank(this.appRegMsg.getRank());
                processInfo.setPort(this.appRegMsg.getPort());
                processInfo.setMPISize(this.appRegMsg.getMPISize());
                processInfo.setRealSize(this.appRegMsg.getRealSize());
                processInfo.setRankTable(this.appRegMsg.getRankTable());
                MPD_Interface.this.parent.procTab.addProcess(processInfo);
            } else if (this.oMsg instanceof StatQueryMessage) {
                StatInfoMessage statInfoMessage = new StatInfoMessage();
                Enumeration enumeration = MPD_Interface.this.parent.procTab.elements();
                while (enumeration.hasMoreElements()) {
                    statInfoMessage.addInfo((ProcessInfo)enumeration.nextElement());
                }
                try {
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(statInfoMessage);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    outputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (this.oMsg instanceof MPDMessage) {
                this.msg = (MPDMessage)this.oMsg;
                switch (this.msg.getCmd()) {
                    case 7: {
                        int n = this.msg.getMinPeers();
                        int n3 = this.msg.getMaxPeers();
                        int n4 = this.msg.getWaitTime();
                        Vector<PipeAdvertisement> vector = MPD_Interface.this.parent.searchMPD(n, n3, n4);
                        String string = this.msg.getID();
                        URI uRI = this.msg.getIP();
                        String string3 = this.msg.getRunCmd();
                        int n5 = n;
                        int n6 = n3 / n + 1;
                        int n7 = vector.size();
                        if (n7 < n) {
                            MPD_Interface.this.log.info((Object)("[JOB] Can not Running " + n3 + " processes on " + n7 + " machines"));
                            FoundNodeMessage foundNodeMessage = new FoundNodeMessage(n7, false);
                            try {
                                objectOutputStream = new ObjectOutputStream(outputStream);
                                objectOutputStream.writeObject(foundNodeMessage);
                                objectOutputStream.flush();
                                objectOutputStream.close();
                                outputStream.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            break;
                        }
                        int n8 = 0;
                        MPD_Interface.this.log.info((Object)("[JOB] Running " + n3 + " processes on " + n7 + " machines"));
                        FoundNodeMessage foundNodeMessage = new FoundNodeMessage(n7, true);
                        try {
                            objectOutputStream = new ObjectOutputStream(outputStream);
                            objectOutputStream.writeObject(foundNodeMessage);
                            objectOutputStream.flush();
                            objectOutputStream.close();
                            outputStream.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        for (int i = 1; i < n6; ++i) {
                            for (int j = 0; j < n5; ++j) {
                                MPDMessage mPDMessage = new MPDMessage(8, string);
                                mPDMessage.setIP(uRI.getHost(), uRI.getPort());
                                mPDMessage.setRunCmd(string3);
                                mPDMessage.setRank(i);
                                MPD_Interface.this.parent.requestPeer(vector.elementAt(n8), mPDMessage);
                                if (++n8 < n7) continue;
                                n8 = 0;
                            }
                        }
                        break;
                    }
                    case 6: {
                        String string = this.msg.getID() + "--" + this.msg.getKey();
                        String string4 = this.msg.getJars();
                        AppInfo appInfo = MPD_Interface.this.parent.hashTable.remove(string);
                        URI uRI = appInfo.getRank0();
                        MPD_Interface.this.log.info((Object)"Running MPI application");
                        MPD_Interface.this.log.info((Object)("Rank 0 : " + appInfo.getRank0().toString()));
                        MPD_Interface.this.log.info((Object)("RunCmd : " + appInfo.getRunCmd()));
                        String string5 = OsInfo.getName();
                        try {
                            String string6 = null;
                            String string7 = string4 + " " + uRI.getHost() + " " + uRI.getPort() + " " + this.msg.getID() + " " + this.msg.getKey() + " " + appInfo.getRunCmd();
                            string6 = OsInfo.isLinux(string5) || OsInfo.isMacosx(string5) ? "p2pclient " + string7 : (OsInfo.isWindows(string5) ? "p2pclient.bat " + string7 : "p2pclient " + string7);
                            MPD_Interface.this.log.debug((Object)("ExeCmd = " + string6));
                            MPD_Interface.this.log.debug((Object)("RunDir = " + this.msg.getRunDir()));
                            Process process = Runtime.getRuntime().exec(string6, null, this.msg.getRunDir());
                            InputStream inputStream2 = process.getErrorStream();
                            InputStream inputStream3 = process.getInputStream();
                            StreamGobbler streamGobbler = new StreamGobbler(inputStream2, true, uRI.getHost(), uRI.getPort());
                            streamGobbler.start();
                            StreamGobbler streamGobbler2 = new StreamGobbler(inputStream3, true, uRI.getHost(), uRI.getPort());
                            streamGobbler2.start();
                            process.waitFor();
                            inputStream2.close();
                            inputStream3.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break;
                    }
                    default: {
                        MPD_Interface.this.log.debug((Object)"Unknown Command");
                    }
                }
            }
            try {
                objectInputStream.close();
                inputStream.close();
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.gc();
        }
    }
}

