/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.fd;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.log4j.Logger;
import p2pmpi.common.GossipConfig;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.fd.GossipDetector;
import p2pmpi.message.GossipMessage;
import p2pmpi.message.RequestQuitMessage;

public class GossipDetectorServer {
    protected static Logger logGos;
    private int serverPort;
    private int mpdPort;
    protected Timer timer;
    Hashtable<String, Vector<GossipDetector>> hashtable;

    public GossipDetectorServer(int n, int n2) {
        this.serverPort = n;
        this.mpdPort = n2;
        this.hashtable = new Hashtable();
        this.timer = new Timer();
        logGos = Logger.getLogger((String)"MPD");
        logGos.debug((Object)"[GossipDetectorServer is online..]");
    }

    public void start() {
        this.timer.schedule((TimerTask)new CheckService(), 0L, (long)GossipConfig.t_checkalive);
        ServerSocket serverSocket = null;
        Socket socket = null;
        Object object = null;
        Vector<GossipDetector> vector = null;
        try {
            serverSocket = new ServerSocket(this.serverPort);
        }
        catch (Exception exception) {
            System.out.println("FD : Can't bind port (" + this.serverPort + ")");
            exception.printStackTrace();
            System.exit(1);
        }
        block9: while (true) {
            try {
                while (true) {
                    InputStream inputStream;
                    ObjectInputStream objectInputStream;
                    if ((object = (objectInputStream = new ObjectInputStream(inputStream = (socket = serverSocket.accept()).getInputStream())).readObject()) instanceof RequestQuitMessage) {
                        System.exit(0);
                    }
                    GossipMessage gossipMessage = (GossipMessage)object;
                    switch (gossipMessage.getCommand()) {
                        case 0: {
                            GossipDetector gossipDetector;
                            String string = gossipMessage.getGossipID();
                            vector = this.hashtable.get(string);
                            logGos.debug((Object)("[GossipServer]: register detector hashID = " + string + "of rank = " + gossipMessage.getMyRank()));
                            if (vector == null) {
                                vector = new Vector();
                                gossipDetector = new GossipDetector(gossipMessage.getMyRank(), string, gossipMessage.getMPIPort(), gossipMessage.getURIList(), this.mpdPort, gossipMessage.getMPIRank());
                                vector.addElement(gossipDetector);
                                this.hashtable.put(string, vector);
                                new Thread(gossipDetector).start();
                                break;
                            }
                            logGos.debug((Object)"[GossipServer]: register a detector same hashID second time");
                            gossipDetector = new GossipDetector(gossipMessage.getMyRank(), string, gossipMessage.getMPIPort(), gossipMessage.getURIList(), this.mpdPort, gossipMessage.getMPIRank());
                            vector.addElement(gossipDetector);
                            new Thread(gossipDetector).start();
                            break;
                        }
                        case 1: {
                            GossipDetector gossipDetector;
                            String string = gossipMessage.getGossipID();
                            int n = gossipMessage.getMyRank();
                            logGos.debug((Object)("[GossipServer]: got gossip message hashID = " + string + " of rank = " + n));
                            vector = this.hashtable.get(string);
                            if (vector == null) continue block9;
                            int n2 = vector.size();
                            int n3 = 0;
                            while (true) {
                                if (n3 >= n2) continue block9;
                                gossipDetector = vector.elementAt(n3);
                                gossipDetector.merge(gossipMessage.getHeartBeatList());
                                ++n3;
                            }
                        }
                        case 2: {
                            int n3;
                            int n2;
                            GossipDetector gossipDetector;
                            String string = gossipMessage.getGossipID();
                            int n = gossipMessage.getMyRank();
                            vector = this.hashtable.get(string);
                            logGos.debug((Object)("[GossipServer]: unregister detector hashID = " + string + "of rank = " + n));
                            if (vector != null) {
                                n2 = vector.size();
                                for (n3 = 0; n3 < n2; ++n3) {
                                    gossipDetector = vector.elementAt(n3);
                                    if (gossipDetector.getMyRank() != n) continue;
                                    gossipDetector.stop();
                                    vector.removeElementAt(n3);
                                    break;
                                }
                            }
                            if (vector.size() != 0) continue block9;
                            this.hashtable.remove(string);
                            break;
                        }
                        default: {
                            logGos.debug((Object)"[GossipServer]: received an unknown message");
                        }
                    }
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public static void main(String[] stringArray) {
        File file = new File(System.getProperty("P2PMPI_HOME"), "P2P-MPI.conf");
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile(file.toString());
        GossipDetectorServer gossipDetectorServer = new GossipDetectorServer(p2PMPI_ConfigFile.getFDPort(), p2PMPI_ConfigFile.getMPDPort());
        gossipDetectorServer.start();
    }

    public class CheckService
    extends TimerTask {
        public void run() {
            Enumeration<String> enumeration = GossipDetectorServer.this.hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Vector<GossipDetector> vector = GossipDetectorServer.this.hashtable.get(string);
                if (vector == null) continue;
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    GossipDetector gossipDetector = vector.elementAt(i);
                    if (gossipDetector.isAlive()) continue;
                    gossipDetector.stop();
                    vector.removeElementAt(i);
                    n = vector.size();
                    --i;
                }
                if (vector.size() != 0) continue;
                GossipDetectorServer.this.hashtable.remove(string);
            }
        }
    }
}

