/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.fd;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import p2pmpi.common.GossipConfig;
import p2pmpi.message.AliveMessage;
import p2pmpi.message.AppUnregisterMessage;
import p2pmpi.message.GossipMessage;
import p2pmpi.message.IsAliveMessage;
import p2pmpi.message.NoAliveMessage;
import p2pmpi.message.NotifyMessage;

public class GossipDetector
implements Runnable {
    protected int myMPIRank;
    protected int myRank;
    protected int mpdPort;
    protected String hashID;
    protected int mpiPort;
    protected URI[] uriList;
    protected boolean[] aliveList;
    protected long[] heartbeatList;
    protected int numPeers;
    protected long T_GOSSIP;
    protected long T_CLEANUP;
    protected Timer timer;
    protected Timer aliveTimer;
    protected volatile boolean alive = true;
    protected static Logger log;

    public GossipDetector(int n, String string, int n2, URI[] uRIArray, int n3, int n4) {
        this.myMPIRank = n4;
        this.myRank = n;
        this.hashID = string;
        this.mpiPort = n2;
        this.uriList = uRIArray;
        this.mpdPort = n3;
        this.T_GOSSIP = GossipConfig.t_period;
        this.numPeers = uRIArray.length;
        this.T_CLEANUP = (int)(Math.log(this.numPeers) / Math.log(2.0)) * 2 + GossipConfig.margin;
        this.aliveList = new boolean[this.numPeers];
        this.heartbeatList = new long[this.numPeers];
        for (int i = 0; i < this.numPeers; ++i) {
            this.aliveList[i] = true;
            this.heartbeatList[i] = 0L;
        }
        this.timer = new Timer();
        this.aliveTimer = new Timer();
        log = Logger.getLogger((String)"MPD");
        log.debug((Object)("[GossipDetector] *** Start gossip for hashID =" + string + " and myRank = " + n));
        log.debug((Object)("[GossipDetector] T_CLEANUP = " + this.T_CLEANUP));
    }

    public void stop() {
        this.timer.cancel();
        this.aliveTimer.cancel();
        log.debug((Object)("[GossipDetector] *** Stop gossip for hashID =" + this.hashID + " and myRank = " + this.myRank));
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void run() {
        this.timer.schedule((TimerTask)new DoGossip(), 0L, this.T_GOSSIP);
        this.aliveTimer.schedule((TimerTask)new CheckAlive(), 0L, (long)GossipConfig.t_appalive);
    }

    public int getMyRank() {
        return this.myRank;
    }

    public void merge(long[] lArray) {
        if (lArray == null) {
            return;
        }
        for (int i = 0; i < this.numPeers; ++i) {
            log.debug((Object)"--------------------");
            if (this.heartbeatList[i] < lArray[i]) {
                this.heartbeatList[i] = lArray[i];
            }
            log.debug((Object)("Node " + i + " : HB = " + this.heartbeatList[i]));
        }
    }

    public class DoGossip
    extends TimerTask {
        int currentStep = 1;
        int maxStep;

        DoGossip() {
            this.maxStep = (int)Math.ceil(Math.log(GossipDetector.this.numPeers) / Math.log(2.0));
        }

        public void run() {
            Object object;
            int n;
            int n2 = GossipDetector.this.myRank;
            GossipDetector.this.heartbeatList[n2] = GossipDetector.this.heartbeatList[n2] + 1L;
            for (n = 0; n < GossipDetector.this.numPeers; ++n) {
                if (!GossipDetector.this.aliveList[n] || GossipDetector.this.heartbeatList[GossipDetector.this.myRank] - GossipDetector.this.heartbeatList[n] <= GossipDetector.this.T_CLEANUP) continue;
                GossipDetector.this.aliveList[n] = false;
                NotifyMessage notifyMessage = new NotifyMessage(n);
                try {
                    Socket socket = new Socket("127.0.0.1", GossipDetector.this.mpiPort);
                    object = socket.getOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
                    objectOutputStream.writeObject(notifyMessage);
                    objectOutputStream.close();
                    ((OutputStream)object).close();
                    socket.close();
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            int n3 = 0;
            int n4 = 1;
            do {
                if ((n = (int)((double)GossipDetector.this.myRank + (double)n4 * Math.pow(2.0, this.currentStep)) + n3) < 0) {
                    n += GossipDetector.this.numPeers;
                    continue;
                }
                n %= GossipDetector.this.numPeers;
            } while ((!GossipDetector.this.aliveList[n] || n == GossipDetector.this.myRank) && ++n3 <= GossipDetector.this.numPeers - 1);
            object = GossipDetector.this.uriList[n].getHost();
            int n5 = GossipDetector.this.uriList[n].getPort();
            GossipMessage gossipMessage = new GossipMessage(1, GossipDetector.this.hashID);
            gossipMessage.setHeartBeatList(GossipDetector.this.heartbeatList);
            try {
                Socket socket = new Socket();
                InetSocketAddress inetSocketAddress = new InetSocketAddress((String)object, n5);
                socket.connect(inetSocketAddress, 1000);
                OutputStream outputStream = socket.getOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(gossipMessage);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++this.currentStep;
            if (this.currentStep > this.maxStep) {
                this.currentStep = 1;
                n4 *= -1;
            }
        }
    }

    public class CheckAlive
    extends TimerTask {
        private void warnMPD() {
            try {
                log.debug((Object)("[GossipDetector:" + GossipDetector.this.hashID + ":" + GossipDetector.this.myRank + "] detect application dead so unregister it to MPD"));
                AppUnregisterMessage appUnregisterMessage = new AppUnregisterMessage(GossipDetector.this.hashID + "--" + GossipDetector.this.myMPIRank);
                Socket socket = new Socket("127.0.0.1", GossipDetector.this.mpdPort);
                OutputStream outputStream = socket.getOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(appUnregisterMessage);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void run() {
            try {
                IsAliveMessage isAliveMessage = new IsAliveMessage(GossipDetector.this.hashID);
                Socket socket = new Socket("127.0.0.1", GossipDetector.this.mpiPort);
                OutputStream outputStream = socket.getOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(isAliveMessage);
                InputStream inputStream = socket.getInputStream();
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                Object object = objectInputStream.readObject();
                if (object instanceof AliveMessage) {
                    AliveMessage aliveMessage = (AliveMessage)object;
                    if (!GossipDetector.this.hashID.equals(aliveMessage.getKey())) {
                        GossipDetector.this.alive = false;
                        GossipDetector.this.aliveTimer.cancel();
                        GossipDetector.this.timer.cancel();
                        this.warnMPD();
                    }
                } else if (object instanceof NoAliveMessage) {
                    GossipDetector.this.alive = false;
                    GossipDetector.this.aliveTimer.cancel();
                    GossipDetector.this.timer.cancel();
                    this.warnMPD();
                }
            }
            catch (Exception exception) {
                log.info((Object)"** My Application is DEAD and did not complete the execution **");
                GossipDetector.this.alive = false;
                GossipDetector.this.aliveTimer.cancel();
                GossipDetector.this.timer.cancel();
                this.warnMPD();
            }
        }
    }
}

